<?php
class Classification
{
	public function __construct()
    {
        add_action( 'init', array($this, 'orto_botanico_create_taxonomy_classification'), 0 );
	}
	
    public function orto_botanico_create_taxonomy_classification() 
    {    
        $labels = array(
            'name'                       => _x( 'Classificazioni', 'Taxonomy General Name', 'orto_botanico' ),
            'singular_name'              => _x( 'Classificazione', 'Taxonomy Singular Name', 'orto_botanico' ),
            'menu_name'                  => __( 'Classificazione', 'orto_botanico' ),
            'all_items'                  => __( 'All Items', 'orto_botanico' ),
            'parent_item'                => __( 'Parent Item', 'orto_botanico' ),
            'parent_item_colon'          => __( 'Parent Item:', 'orto_botanico' ),
            'new_item_name'              => __( 'New Item Name', 'orto_botanico' ),
            'add_new_item'               => __( 'Add New Item', 'orto_botanico' ),
            'edit_item'                  => __( 'Edit Item', 'orto_botanico' ),
            'update_item'                => __( 'Update Item', 'orto_botanico' ),
            'view_item'                  => __( 'View Item', 'orto_botanico' ),
            'separate_items_with_commas' => __( 'Separate items with commas', 'orto_botanico' ),
            'add_or_remove_items'        => __( 'Add or remove items', 'orto_botanico' ),
            'choose_from_most_used'      => __( 'Choose from the most used', 'orto_botanico' ),
            'popular_items'              => __( 'Popular Items', 'orto_botanico' ),
            'search_items'               => __( 'Search Items', 'orto_botanico' ),
            'not_found'                  => __( 'Not Found', 'orto_botanico' ),
            'no_terms'                   => __( 'No items', 'orto_botanico' ),
            'items_list'                 => __( 'Items list', 'orto_botanico' ),
            'items_list_navigation'      => __( 'Items list navigation', 'orto_botanico' ),
        );
        $args = array(
            'labels'                     => $labels,
            'hierarchical'               => true,
            'public'                     => true,
            'show_ui'                    => true,
            'show_admin_column'          => true,
            'show_in_nav_menus'          => true,
            'show_tagcloud'              => true,
        );
        register_taxonomy( 'classification', array( 'plant' ), $args );
    }
}