<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Create a helper function for easy SDK access.
function dgoraAsfwFs() {
    global $dgoraAsfwFs;
    if ( !isset( $dgoraAsfwFs ) ) {
        // Include Freemius SDK.
        require_once dirname( __FILE__ ) . '/lib/start.php';
        // Activate multisite network integration.
        if ( !defined( 'WP_FS__PRODUCT_700_MULTISITE' ) ) {
            define( 'WP_FS__PRODUCT_700_MULTISITE', true );
        }
        $dgoraAsfwFs = fs_dynamic_init( array(
            'id'             => '700',
            'slug'           => 'ajax-search-for-woocommerce',
            'type'           => 'plugin',
            'public_key'     => 'pk_f4f2a51dbe0aee43de0692db77a3e',
            'is_premium'     => true,
            'premium_suffix' => 'Pro',
            'has_addons'     => false,
            'has_paid_plans' => true,
            'menu'           => array(
                'slug'        => 'dgwt_wcas_settings',
                'parent'      => array(
                    'slug' => 'woocommerce',
                ),
                'account'     => false,
                'contact'     => false,
                'support'     => false,
                'pricing'     => false,
                'affiliation' => false,
            ),
            'is_live'        => true,
        ) );
    }
    return $dgoraAsfwFs;
}

// Init Freemius.
dgoraAsfwFs();
// Signal that SDK was initiated.
do_action( 'dgoraAsfwFs_loaded' );
dgoraAsfwFs()->add_filter( 'plugin_icon', function () {
    return dirname( dirname( __FILE__ ) ) . '/assets/img/logo-128.png';
} );
// Uninstall
if ( dgoraAsfwFs()->is__premium_only() ) {
    dgoraAsfwFs()->add_action( 'after_uninstall', function () {
        global $wpdb;
        /* --------------------
         * WIPE DATABASE TABLES
         * -------------------- */
        $pluginTables = array();
        $tables = $wpdb->get_results( "SHOW TABLES" );
        if ( !empty( $tables ) && is_array( $tables ) ) {
            foreach ( $tables as $table ) {
                if ( !empty( $table ) && is_object( $table ) ) {
                    foreach ( $table as $tableName ) {
                        if ( !empty( $tableName ) && is_string( $tableName ) && strpos( $tableName, 'dgwt_wcas_' ) !== false ) {
                            $pluginTables[] = $tableName;
                        }
                    }
                }
            }
        }
        foreach ( $pluginTables as $table ) {
            $wpdb->query( "DROP TABLE IF EXISTS {$table}" );
        }
        /* ------------
         * WIPE OPTIONS
         * ------------ */
        $wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->options} WHERE option_name LIKE 'dgwt_wcas_indexer_last_build%'" ) );
        $options = array(
            'dgwt_wcas_schedule_single',
            'dgwt_wcas_schedule_last_data',
            'dgwt_wcas_inv_index_db_version',
            'dgwt_wcas_index_db_version',
            'dgwt_wcas_tax_index_db_version',
            'dgwt_wcas_var_index_db_version',
            'dgwt_wcas_ven_index_db_version',
            'dgwt_wcas_settings_show_advanced',
            'dgwt_wcas_db_json_support',
            'dgwt_wcas_images_regenerated',
            'dgwt_wcas_debug_search_logs',
            'dgwt_wcas_settings_version',
            'dgwt_wcas_settings_version_pro',
            'dgwt_wcas_indexer_prepare_process_exist',
            'dgwt_wcas_activation_date',
            'dgwt_wcas_dismiss_review_notice',
            'dgwt_wcas_indexer_last_failure_data',
            'dgwt_wcas_auto_send_indexer_failure_reports',
            'dgwt_wcas_dismiss_indexer_failure_notices',
            'dgwt_wcas_db_locking_support',
            'dgwt_wcas_stats_db_version',
            'widget_dgwt_wcas_ajax_search'
        );
        foreach ( $options as $option ) {
            delete_option( $option );
        }
        /* ----------------------
         * WIPE TRANSIENTS
         * --------------------- */
        $transients = array(
            'dgwt_wcas_indexer_details_display',
            'dgwt_wcas_searchable_custom_fields',
            'dgwt_wcas_troubleshooting_async_results',
            'dgwt_wcas_indexer_debug',
            'dgwt_wcas_indexer_debug_scope'
        );
        foreach ( $transients as $transient ) {
            delete_transient( $transient );
        }
        /* --------------------------------------
         * WIPE ACTION SCHEDULER LOGS AND ACTIONS
         * -------------------------------------- */
        $logIds = $wpdb->get_col( "SELECT action_id FROM {$wpdb->prefix}actionscheduler_actions WHERE hook = 'dgwt/wcas/tnt/background_product_update'" );
        $placeholders = array_fill( 0, count( $logIds ), '%d' );
        $format = implode( ', ', $placeholders );
        $wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->prefix}actionscheduler_logs WHERE action_id IN ({$format})", $logIds ) );
        $wpdb->query( "DELETE FROM {$wpdb->prefix}actionscheduler_actions WHERE hook = 'dgwt/wcas/tnt/background_product_update'" );
        if ( is_multisite() ) {
            foreach ( get_sites() as $site ) {
                if ( is_numeric( $site->blog_id ) && $site->blog_id > 1 ) {
                    $table = $wpdb->prefix . $site->blog_id . '_' . 'options';
                    $wpdb->query( $wpdb->prepare( "DELETE FROM {$table} WHERE option_name LIKE 'dgwt_wcas_indexer_last_build%'" ) );
                    foreach ( $options as $option ) {
                        $wpdb->delete( $table, array(
                            'option_name' => $option,
                        ) );
                    }
                    foreach ( $transients as $transient ) {
                        $wpdb->delete( $table, array(
                            'option_name' => '_transient_' . $transient,
                        ) );
                        $wpdb->delete( $table, array(
                            'option_name' => '_transient_timeout_' . $transient,
                        ) );
                    }
                    // Action Scheduler logs and actions.
                    $asActionsTable = $wpdb->prefix . $site->blog_id . '_' . 'actionscheduler_actions';
                    $asLogsTable = $wpdb->prefix . $site->blog_id . '_' . 'actionscheduler_logs';
                    $logIds = $wpdb->get_col( "SELECT action_id FROM {$asActionsTable} WHERE hook = 'dgwt/wcas/tnt/background_product_update'" );
                    $placeholders = array_fill( 0, count( $logIds ), '%d' );
                    $format = implode( ', ', $placeholders );
                    $wpdb->query( $wpdb->prepare( "DELETE FROM {$asLogsTable} WHERE action_id IN ({$format})", $logIds ) );
                    $wpdb->query( "DELETE FROM {$asActionsTable} WHERE hook = 'dgwt/wcas/tnt/background_product_update'" );
                }
            }
        }
        /* ---------
         * WIPE LOGS
         * --------- */
        if ( class_exists( 'WC_Log_Handler_File' ) ) {
            $wcLogHandler = new \WC_Log_Handler_File();
            foreach ( ['fibosearch-updater', 'fibosearch-fail-indexer', 'fibosearch-indexer'] as $source ) {
                $files = $wcLogHandler->get_log_files();
                foreach ( $files as $handle => $filename ) {
                    if ( strpos( $handle, $source ) !== false ) {
                        $wcLogHandler->remove( $handle );
                    }
                }
            }
        }
    } );
}
if ( !dgoraAsfwFs()->is_premium() ) {
    dgoraAsfwFs()->add_action( 'after_uninstall', function () {
        global $wpdb;
        /* ------------
         * WIPE OPTIONS
         * ------------ */
        $options = array(
            'dgwt_wcas_schedule_single',
            'dgwt_wcas_settings_show_advanced',
            'dgwt_wcas_images_regenerated',
            'dgwt_wcas_settings_version',
            'dgwt_wcas_activation_date',
            'dgwt_wcas_dismiss_review_notice',
            'dgwt_wcas_stats_db_version',
            'widget_dgwt_wcas_ajax_search'
        );
        foreach ( $options as $option ) {
            delete_option( $option );
        }
        /* ---------------
         * WIPE TRANSIENTS
         * --------------- */
        $transients = array('dgwt_wcas_troubleshooting_async_results');
        foreach ( $transients as $transient ) {
            delete_transient( $transient );
        }
        if ( is_multisite() ) {
            foreach ( get_sites() as $site ) {
                if ( is_numeric( $site->blog_id ) && $site->blog_id > 1 ) {
                    $table = $wpdb->prefix . $site->blog_id . '_' . 'options';
                    foreach ( $options as $option ) {
                        $wpdb->delete( $table, array(
                            'option_name' => $option,
                        ) );
                    }
                    foreach ( $transients as $transient ) {
                        $wpdb->delete( $table, array(
                            'option_name' => '_transient_' . $transient,
                        ) );
                        $wpdb->delete( $table, array(
                            'option_name' => '_transient_timeout_' . $transient,
                        ) );
                    }
                }
            }
        }
    } );
}