<?php
/**
 * Class for retrieving product data based on user selected feed configuration.
 *
 * Get the product data based on feed config selected by user.
 *
 * @package    Rex_Product_Data_Retriever_Pro
 * @subpackage Rex_Product_Feed/admin
 * @author     RexTheme <info@rextheme.com>
 */
class Rex_Product_Data_Retriever_Pro extends Rex_Product_Data_Retriever {

    /**
     * @desc Set value for a single feed rule.
     * @since    7.3.0
     * @param $rule
     * @return array|mixed|string|string[]|null
     */
    public function set_val( $rule )
    {
        if ( 'combined' === $rule[ 'type' ] && isset( $rule[ 'combined_key' ] ) ) {
            $combined_attr_actual = $rule[ 'combined_key' ];
            $combined_attr = self::get_separated_combined_attr( $rule[ 'combined_key' ] );

            if ( !empty( $combined_attr ) ) {
                foreach ( $combined_attr as $attr ) {
                    $rule[ 'type' ] = 'meta';
                    $rule[ 'meta_key' ] = $attr;
                    $combined_attr_actual = str_replace( '{' . $attr . '}', parent::set_val( $rule ), $combined_attr_actual );
                }
            }
            return $combined_attr_actual;
        }
        else {
            $val = parent::set_val($rule);
        }
        // maybe replace
        return $this->maybe_replaced( $rule, $val, $this->feed_rules );
    }

    /**
     * Replace a string from an attribute
     * @since 7.3.0
     * @param $attr
     * @param $value
     * @param $feed_rules
     * @return array|false|int|mixed|string|string[]|WC_DateTime|NULL
     */
    protected function maybe_replaced( $attr, $value, $feed_rules )
    {
        $attr_name = isset( $attr[ 'meta_key' ] ) ? $attr[ 'meta_key' ] : '';
        $attr_name = $attr_name === '' && isset( $attr[ 'attr' ] ) ? $attr[ 'attr' ] : $attr_name;
        $attr_name = $attr_name === '' && isset( $attr[ 'cust_attr' ] ) ? $attr[ 'cust_attr' ] : $attr_name;

        if( is_array( $feed_rules ) && !empty( $feed_rules ) ) {
            foreach( $feed_rules as $rule ) {
                $rule_then = isset( $rule['rules_then'] ) ? $rule['rules_then'] : '';

                if( $attr_name === $rule_then ) {
                    $rule_if = '';
                    $rule_replace = '';

                    if( isset( $rule['rules_if'] ) && $rule['rules_if'] !== '' ) {
                        $rule_if = $rule['rules_if'];
                    }
                    elseif( isset( $rule['cust_rules_if'] ) && $rule['cust_rules_if'] !== '' ) {
                        $rule_if = $rule['cust_rules_if'];
                    }

                    if( isset( $rule['rules_replace'] ) && !isset( $rule['rules_static'] ) ) {
                        $rule_replace = $rule['rules_replace'];
                        $rule_replace = $this->get_rules_new_value( $rule_replace );
                    }
                    elseif( isset( $rule['rules_static_replace'] ) && isset( $rule['rules_static'] ) && 'static' === $rule['rules_static'] ) {
                        $rule_replace = $rule['rules_static_replace'];
                    }

                    $if_attr_val = $this->get_rules_new_value( $rule_if );
                    $rule_condition = isset( $rule[ 'rules_condition' ] ) ? $rule[ 'rules_condition' ] : '';
                    $rule_find = isset( $rule['rules_find'] ) ? $rule['rules_find'] : '';

                    switch( $rule_condition ) {
                        case 'contain':
                            if ( preg_match('/' . $rule_find . '/i', $if_attr_val ) ) {
                                $value = $rule_replace;
                            }
                            break;
                        case 'dn_contain':
                            $str_contains = preg_match( "/$rule_find\b/", $if_attr_val);
                            $value = ! $str_contains ? $rule_replace : $value;
                            break;
                        case 'equal_to':
                            $value = $if_attr_val == $rule_find ? $rule_replace : $value;
                            break;
                        case 'nequal_to':
                            $value = $if_attr_val != $rule_find ? $rule_replace : $value;
                            break;
                        case 'greater_than':
                            $value = $if_attr_val > $rule_find ? $rule_replace : $value;
                            break;
                        case 'greater_than_equal':
                            $value = $if_attr_val >= $rule_find ? $rule_replace : $value;
                            break;
                        case 'less_than':
                            $value = $if_attr_val < $rule_find ? $rule_replace : $value;
                            break;
                        case 'less_than_equal':
                            $value = $if_attr_val <= $rule_find ? $rule_replace : $value;
                            break;
                        default:
                            break;
                    }
                }
            }
            return $value;
        }

        return $value;
    }


    /**
     * @desc Get new attribute value for feed rules
     * @since 7.3.0
     * @param $type
     * @param $key
     * @param $value
     * @return false|int|mixed|string|WC_DateTime|NULL
     */
    protected function get_rules_new_value( $key, $type = 'meta' ) {
        if( 'meta' === $type && $this->is_primary_attr( $key ) ) {
            return $this->set_pr_att( $key );
        }
        elseif( 'meta' === $type && $this->is_woodmart_attr( $key ) ) {
            return $this->set_woodmart_att( $key );
        }
        elseif( 'meta' === $type && $this->is_price_attr( $key ) ) {
            return $this->set_price_attr( $key );
        }
        elseif( 'meta' === $type && $this->is_yoast_attr( $key ) ) {
            return $this->set_yoast_attr( $key );
        }
        elseif( 'meta' === $type && $this->is_perfect_attr( $key ) ) {
            return $this->set_perfect_attr( $key );
        }
        elseif( 'meta' === $type && $this->is_wc_brand_attr( $key ) ) {
            return $this->set_wc_brand_attr( $key );
        }
        elseif( 'meta' === $type && $this->is_berocket_brand_attr( $key ) ) {
            return $this->set_berocket_brand_attr( $key );
        }
        elseif( 'meta' === $type && $this->is_image_attr( $key ) ) {
            return $this->set_image_att( $key );
        }
        elseif( 'meta' === $type && $this->is_product_attr( $key ) ) {
            return $this->set_product_attr( $key );
        }
        elseif( 'meta' === $type && $this->is_product_dynamic_attr( $key ) ) {
            return $this->set_product_dynamic_attr( $key );
        }
        elseif( 'meta' === $type && $this->is_wpfm_custom_attr( $key ) ) {
            return $this->set_wpfm_custom_att( $key );
        }
        elseif( 'meta' === $type && $this->is_product_custom_attr( $key ) ) {
            return $this->set_product_custom_att( $key );
        }
        elseif( 'meta' === $type && $this->is_product_category_mapper_attr( $key ) ) {
            return $this->set_cat_mapper_att( $key );
        }
        elseif( 'meta' === $type && $this->is_glami_attr( $key ) ) {
            return $this->set_glami_att( $key );
        }
        elseif( 'meta' === $type && $this->is_dropship_attr( $key ) ) {
            return $this->set_dropship_att( $key );
        }
        elseif( 'meta' === $type && $this->is_date_attr( $key ) ) {
            return $this->set_date_attr( $key );
        }
        elseif ( 'meta' === $type && $this->is_product_custom_tax( $key ) ) {
            return $this->set_product_custom_tax( $key  );
        }
        elseif ( 'meta' === $type && $this->is_woo_discount_rules( $key ) ) {
            return $this->set_woo_discount_rules( $key  );
        }
        return '';
    }


    /**
     * @desc Retrieves dynamic price value
     * @since 7.3.0
     * @param $rule
     * @param $price
     * @return float|string
     */
    public static function get_dynamic_price( $rule, $price )
    {
        $is_premium = apply_filters( 'wpfm_is_premium', false );

        if( $is_premium ) {
            $price      = $price === '' ? 0 : $price;
            $expression = isset( $rule[ 'limit' ] ) ? $rule[ 'limit' ] : '';
            $operators  = preg_split( '([^\\+\\-*\\/\^])', trim( $expression ) );
            $operators  = array_values( array_filter( $operators ) );
            $numbers    = preg_split( '/[^0-9\%]/', trim( $expression ) );
            $numbers    = array_values( array_filter( $numbers ) );
            $i          = 0;

            foreach( $operators as $operator ) {
                switch( $operator ) {
                    case '+':
                        (float)$price += (float)rex_feed_get_percentage( $numbers[ $i++ ], $price );
                        break;
                    case '-':
                        (float)$price -= (float)rex_feed_get_percentage( $numbers[ $i++ ], $price );
                        break;
                    case '*':
                        (float)$price *= (float)rex_feed_get_percentage( $numbers[ $i++ ], $price );
                        break;
                    case '/':
                        (float)$price /= (float)rex_feed_get_percentage( $numbers[ $i++ ], $price );
                        break;
                    default:
                        break;
                }
            }
        }

        return $price == 0 ? '' : (float)$price;
    }


    /**
     * @desc Helper function for dynamic price
     * @since 7.3.0
     * @param $number
     * @param $price
     * @return float
     */
    public static function get_percentage( $number, $price )
    {
        if( strpos( $number, '%' ) !== false ) {
            $number = str_replace( '', '%', $number );
            return (float)$price * ( (float)$number / 100 );
        }
        return (float)$number;
    }


    /**
     * @desc Separates the combined attributes from a string and
     * returns in an array
     * @since 6.2.2
     * @param $attributes
     * @return string[]
     */
    private static function get_separated_combined_attr( $attributes ) {
        $attributes = preg_split('/({|})/', $attributes);
        return array_values( array_filter( $attributes ) );
    }
}