<?php

/**
 * The file that generates xml feed for any merchant with custom configuration.
 *
 * A class definition that includes functions used for generating xml feed.
 *
 * @link       https://rextheme.com
 * @since      1.0.0
 *
 * @package    Rex_Product_Feed_Ebay_mip
 * @subpackage Rex_Product_Feed_Ebay_mip/includes
 * @author     RexTheme <info@rextheme.com>
 */

use RexTheme\RexShoppingFeedCustom\EbayMip\Containers\RexShoppingCustom;


class Rex_Product_Feed_Ebay_mip extends Rex_Product_Feed_Abstract_Generator {


    /**
     * Create Feed
     *
     * @return boolean
     * @author
     **/
    public function make_feed() {

        RexShoppingCustom::$container = null;
        RexShoppingCustom::init(false, 'product', null, '', 'productRequest');

        // Generate feed for both simple and variable products.
        $this->generate_product_feed();

        $this->feed = $this->returnFinalProduct();

        if ($this->batch >= $this->tbatch ) {
            $this->save_feed($this->feed_format);
            return array(
                'msg' => 'finish'
            );
        }else {
            return $this->save_feed($this->feed_format);
        }
    }


    /**
     * generate feed array
     */
    protected function generate_product_feed(){
        $product_meta_keys = Rex_Feed_Attributes::get_attributes();
        $simple_products = [];
        $variation_products = [];
        $variable_parent = [];
        $group_products = [];
        $total_products = get_post_meta($this->id, '_rex_feed_total_products', true) ?: get_post_meta($this->id, 'rex_feed_total_products', true);
        $total_products = $total_products ?: array(
            'total' => 0,
            'simple' => 0,
            'variable' => 0,
            'variable_parent' => 0,
            'group' => 0,
        );

        if($this->batch == 1) {
            $total_products = array(
                'total' => 0,
                'simple' => 0,
                'variable' => 0,
                'variable_parent' => 0,
                'group' => 0,
            );
        }

        foreach( $this->products as $productId ) {
            $product = wc_get_product( $productId );

            if ( ! is_object( $product ) ) {
                continue;
            }

            if ( $this->exclude_hidden_products ) {
                if ( !$product->is_visible() ) {
                    continue;
                }
            }

            if ( ( !$this->include_out_of_stock )
                && ( !$product->is_in_stock()
                    || $product->is_on_backorder()
                    || (is_integer($product->get_stock_quantity()) && 0 >= $product->get_stock_quantity())
                )
            ) {
                continue;
            }

            if ( $product->is_type( 'variable' ) && $product->has_child() ) {
                if($this->variable_product) {
                    $variable_parent[] = $productId;
                    $variable_product = new WC_Product_Variable($productId);
                    $atts = $this->get_product_data( $variable_product, $product_meta_keys );
                    $item = RexShoppingCustom::createItem();
                    foreach ($atts as $key => $value) {
	                    if ( $this->rex_feed_skip_row && $this->feed_format === 'xml' ) {
		                    if ( $value != '' ) {
			                    $item->$key($value); // invoke $key as method of $item object.
		                    }
	                    }
	                    else {
	                    	$value = $key === 'Variation Group ID' ? $productId : $value;
		                    $item->$key($value); // invoke $key as method of $item object.
	                    }
                    }
                }

                if($this->product_scope === 'product_cat' || $this->product_scope === 'product_tag' || $this->product_scope === 'filter') {
                    if ( $this->exclude_hidden_products ) {
                        $variations = $product->get_visible_children();
                    }else {
                        $variations = $product->get_children();
                    }
                    if($variations) {
                        foreach ($variations as $variation) {
                            if($this->variations) {
                                $variation_products[] = $variation;
                                $item = RexShoppingCustom::createItem();
                                $variation_product = wc_get_product( $variation );
                                if ( ( !$this->include_out_of_stock )
                                    && ( !$variation_product->is_in_stock()
                                        || $variation_product->is_on_backorder()
                                        || (is_integer($variation_product->get_stock_quantity()) && 0 >= $variation_product->get_stock_quantity())
                                    )
                                ) {
                                    continue;
                                }
                                $atts = $this->get_product_data( $variation_product, $product_meta_keys );

                                $_variation_atts = $variation_product->get_variation_attributes();
                                $formatted_variation_atts = [];
                                if($_variation_atts) {
                                    foreach ($_variation_atts as $_key => $_val) {
                                        $searchVal = array("attribute_pa_", "pa_");
                                        $name = str_replace($searchVal, '', $_key);
                                        $formatted_variation_atts[] = array(
                                            'name' => ucfirst($name),
                                            'value' => ucfirst($_val)
                                        );
                                    }
                                }
                                for ( $i=0; $i < 5; $i++ ) {
                                    if(isset($formatted_variation_atts[$i])) {
                                        $atts['Variation Specific Name '.($i+1)] = $formatted_variation_atts[$i]['name'];
                                        $atts['Variation Specific Value '.($i+1)] = $formatted_variation_atts[$i]['value'];
                                    }else {
                                        $atts['Variation Specific Name '.($i+1)] = '';
                                        $atts['Variation Specific Value '.($i+1)] = '';
                                    }
                                }
                                foreach ($atts as $key => $value) {
	                                if ( $this->rex_feed_skip_row && $this->feed_format === 'xml' ) {
		                                if ( $value != '' ) {
			                                $item->$key($value); // invoke $key as method of $item object.
		                                }
	                                }
	                                else {
		                                $value = preg_match( '/Attribute/i', $key ) ? '' : $value;
		                                $item->$key($value); // invoke $key as method of $item object.
	                                }
                                }
                            }
                        }
                    }
                }
            }

            if ( $product->is_type( 'simple' ) || $product->is_type( 'external' ) || $product->is_type( 'composite' ) || $product->is_type( 'bundle' )) {
                $simple_products[] = $productId;
                $atts = $this->get_product_data( $product, $product_meta_keys );
                $item = RexShoppingCustom::createItem();
                for ( $i=0; $i < 5; $i++ ) {
                    $atts['Variation Specific Name '.($i+1)] = '';
                    $atts['Variation Specific Value '.($i+1)] = '';
                }
                foreach ($atts as $key => $value) {
	                if ( $this->rex_feed_skip_row && $this->feed_format === 'xml' ) {
		                if ( $value != '' ) {
			                $item->$key($value); // invoke $key as method of $item object.
		                }
	                }
	                else {
		                $item->$key($value); // invoke $key as method of $item object.
	                }
                }
            }

            if( $this->product_scope === 'all' || $this->product_scope =='product_filter') {
                if ($product->get_type() == 'variation') {
                    $variation_products[] = $productId;
                    $item = RexShoppingCustom::createItem();
                    $atts = $this->get_product_data($product, $product_meta_keys);

                    $_variation_atts = $product->get_variation_attributes();
                    $formatted_variation_atts = [];
                    if($_variation_atts) {
                        foreach ($_variation_atts as $_key => $_val) {
                            $searchVal = array("attribute_pa_", "pa_");
                            $name = str_replace($searchVal, '', $_key);
                            $formatted_variation_atts[] = array(
                                'name' => ucfirst($name),
                                'value' => ucfirst($_val)
                            );
                        }
                    }
                    for ( $i=0; $i < 5; $i++ ) {
                        if(isset($formatted_variation_atts[$i])) {
                            $atts['Variation Specific Name '.($i+1)] = $formatted_variation_atts[$i]['name'];
                            $atts['Variation Specific Value '.($i+1)] = $formatted_variation_atts[$i]['value'];
                        }else {
                            $atts['Variation Specific Name '.($i+1)] = '';
                            $atts['Variation Specific Value '.($i+1)] = '';
                        }
                    }

                    foreach ($atts as $key => $value) {
	                    if ( $this->rex_feed_skip_row && $this->feed_format === 'xml' ) {
		                    if ( $value != '' ) {
			                    $item->$key($value); // invoke $key as method of $item object.
		                    }
	                    }
	                    else {
		                    $value = preg_match( '/Attribute/i', $key ) ? '' : $value;
		                    $item->$key($value); // invoke $key as method of $item object.
	                    }
                    }
                }
            }

            if( $product->is_type( 'grouped' ) && $this->parent_product ){
                $group_products[] = $productId;
                $item = RexShoppingCustom::createItem();
                $atts = $this->get_product_data( $product, $product_meta_keys );
                // add all attributes for each product.
                foreach ($atts as $key => $value) {
	                if ( $this->rex_feed_skip_row && $this->feed_format === 'xml' ) {
		                if ( $value != '' ) {
			                $item->$key($value); // invoke $key as method of $item object.
		                }
	                }
	                else {
		                $item->$key($value); // invoke $key as method of $item object.
	                }
                }
            }

        }

        $total_products = array(
            'total' => (int) $total_products['total'] + (int) count($simple_products) + (int) count($variation_products) + (int) count($group_products) + (int) count($variable_parent),
            'simple' => (int) $total_products['simple'] + (int) count($simple_products),
            'variable' => (int) $total_products['variable'] + (int) count($variation_products),
            'variable_parent' => (int) $total_products['variable_parent'] + (int) count($variable_parent),
            'group' => (int) $total_products['group'] + (int) count($group_products),
        );
        update_post_meta( $this->id, '_rex_feed_total_products', $total_products );
	    if ( $this->tbatch === $this->batch ) {
		    update_post_meta( $this->id, '_rex_feed_total_products_for_all_feed', $total_products[ 'total' ] );
	    }
    }


    /**
     * Check if the merchants is valid or not
     * @param $feed_merchants
     * @return bool
     */
    public function is_valid_merchant(){
        return array_key_exists($this->merchant, $this->feed_merchants)? true : false;
    }


    /**
     * Return Feed
     *
     * @return array|bool|string
     */
    public function returnFinalProduct(){
    	if ( $this->feed_format === 'csv' ) {
		    return RexShoppingCustom::asCsv();
	    }
        return RexShoppingCustom::asRss();
    }

    public function footer_replace() {
        $this->feed = str_replace('</productRequest>', '', $this->feed);
    }


}
