<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is display the custom filter for product
 *
 * @link       https://rextheme.com
 * @since      1.1.10
 *
 * @package    Rex_Product_Feed
 * @subpackage Rex_Product_Feed/admin/partials
 */


// Exit if $feed_template obj isn't available.
if ( ! isset($feed_filter) ) {
    return;
}

unset($feed_filter->getFilterMappings()['Primary Attributes']['product_cats']);
unset($feed_filter->getFilterMappings()['Primary Attributes']['product_tags']);
$is_premium = apply_filters('wpfm_is_premium_activate', false);
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->

<?php
if ( wpfm_pro_compatibility() ) {
    do_action( 'wpfm_pro_filter_rules' );
}
?>

<div class="rex-feed-filer-rules-header">	
    <label for="rex_feed_filer-rules">
        <?php _e('Feed Rules', 'rex-product-feed-pro' )?>
        <span class="rex_feed-tooltip">
            <?php include plugin_dir_path(__FILE__) . '../assets/icon/icon-svg/icon-question.php';?>
            <p><?php esc_html_e( 'Manipulate your feed data with your preferred condition', 'rex-product-feed' ); ?></p>
        </span>
    </label>

    <a href="<?php echo esc_url( 'https://rextheme.com/docs/how-to-use-the-product-rule-feature-to-manipulate-feed-values/' )?>" target="_blank">
        <?php esc_html_e('Learn How', 'rex-product-feed')?>
    </a>
</div>

<!-- <h2 class="filer-rules-header">Feed Rules</h2> -->
<div class="rex__filter-table">
    <table id="config-table" class="filter-config-table responsive-table">
        <thead>
        <tr>
            <th class="2"><?php echo __('If', 'rex-product-feed') ?><span>*</span></th>
            <th class="2"><?php echo __('Condition', 'rex-product-feed') ?><span>*</span></th>
            <th class="2"><?php echo __('Find', 'rex-product-feed') ?></th>
            <th class="2"><?php echo __('Then', 'rex-product-feed') ?></th>
            <th class="2"><?php echo __('Static', 'rex-product-feed') ?></th>
            <th class="2"><?php echo __('Replace', 'rex-product-feed') ?></th>
            <th class="2"><?php echo __('Action', 'rex-product-feed') ?></th>
        </tr>
        </thead>

        <tbody>

        <?php
        $keyt = rand(999, 3000); ?>
        <tr data-row-id="<?php echo $keyt; ?>" style="display: none;">
            <td data-title="rules_if : "><?php $feed_filter->printSelectDropdown( $keyt, 'rules_if', 'fr', '', '', '' ); ?></td>
            <td data-title="rules_condition : "><?php $feed_filter->printSelectDropdown( $keyt, 'rules_condition', 'fr', '' ); ?></td>
            <td data-title="rules_find : " ><?php $feed_filter->printInput( $keyt, 'rules_find', 'fr', '' ); ?></td>
            <td data-title="rules_then : " ><?php $feed_filter->printSelectDropdown( $keyt, 'rules_then', 'fr', '', '', '' ); ?></td>
            <td data-title="rules_static : "><input type="checkbox" name="fr[<?php echo $keyt;?>][rules_static]" value="static"  class="rex-feed-rule-static"></td>
            <td data-title="rules_replace : ">
                <?php $feed_filter->printInput( $keyt, 'rules_static_replace', 'fr', '', 'rules_static_replace', 'display: none' ); ?>
                <?php $feed_filter->printSelectDropdown( $keyt, 'rules_replace', 'fr', '', 'rules_dropdown_replace', '' ); ?>
            </td>
            <td>
                <a class="delete-row" title="Delete">
                    <i class="fa fa-trash"></i>
                </a>
            </td>
        </tr>

        <?php foreach ( $feed_filter->getFilterMappings() as $key => $item):
            $rules_if = isset( $item[ 'rules_if' ] ) ? $item[ 'rules_if' ] : '';
            $rules_custom_if = isset( $item[ 'cust_rules_if' ] ) ? $item[ 'cust_rules_if' ] : '';
            $rules_condition = isset( $item[ 'rules_condition' ] ) ? $item[ 'rules_condition' ] : '';
            $rules_find = isset( $item[ 'rules_find' ] ) ? $item[ 'rules_find' ] : '';
            $rules_then = isset( $item[ 'rules_then' ] ) ? $item[ 'rules_then' ] : '';
            $rules_static = isset( $item[ 'rules_static' ] ) && $item[ 'rules_static' ] === 'static' ? 'checked' : '';
            $rules_replace = '';
            $static_checked = '';
            $dropdown_checked = '';

            if( $rules_static === 'checked' ) {
                $rules_replace = isset( $item[ 'rules_static_replace' ] ) ? $item[ 'rules_static_replace' ] : $rules_replace;
                $dropdown_checked = 'display: none';
            }
            else {
                $rules_replace = isset( $item[ 'rules_replace' ] ) ? $item[ 'rules_replace' ] : $rules_replace;
                $static_checked = 'display: none';
            }
            ?>
            <tr data-row-id="<?php echo $key; ?>">
                <?php if( ($rules_if !== '') || ( $rules_if === '' && $rules_custom_if === '' ) ) {?>
                <td data-title="rules_if : "><?php $feed_filter->printSelectDropdown( $key, 'rules_if', 'fr', $rules_if, 'feed-rules-attr-dropdown', '' ); ?></td>
                <?php }
                if( $rules_custom_if !== '' ) {?>
                <td data-title="cust_rules_if : "><?php $feed_filter->printInput( $key, 'cust_rules_if', 'fr', $rules_custom_if ); ?></td>
                <?php } ?>
                <td  data-title="rules_condition : "><?php $feed_filter->printSelectDropdown( $key, 'rules_condition', 'fr', $rules_condition ); ?></td>
                <td data-title="rules_find : "><?php $feed_filter->printInput( $key, 'rules_find', 'fr', $rules_find ); ?></td>
                <td data-title="rules_then : "><?php $feed_filter->printSelectDropdown( $key, 'rules_then', 'fr', $rules_then, 'feed-rules-attr-dropdown', '' ); ?></td>
                <td data-title="rules_static : "><input type="checkbox" name="fr[<?php echo $key?>][rules_static]" value="static" class="rex-feed-rule-static" <?php echo $rules_static?>></td>
                <td data-title="rules_replace : ">
                    <?php $feed_filter->printInput( $key, 'rules_static_replace', 'fr', $rules_replace, 'rules_static_replace', $static_checked ); ?>
                    <?php $feed_filter->printSelectDropdown( $key, 'rules_replace', 'fr', $rules_replace, 'rules_dropdown_replace', $dropdown_checked ); ?>
                </td>
                <td>
                    <a class="delete-row" title="Delete">
                        <i class="fa fa-trash"></i>
                    </a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>