<?php
if ( ! function_exists( 'wpfm_find_matching_product_variation' ) ) {
    /**
     * Find the matching variable ID
     *
     * @param $product
     * @param $attributes
     * @return mixed
     * @throws Exception
     */
    function wpfm_find_matching_product_variation($product, $attributes)
    {
        foreach ($attributes as $key => $value) {
            if (strpos($key, 'attribute_') === 0) {
                continue;
            }
            unset($attributes[$key]);
            $attributes[sprintf('attribute_%s', $key)] = $value;
        }
        if (class_exists('WC_Data_Store')) {
            $data_store = WC_Data_Store::load('product');
            return $data_store->find_matching_product_variation($product, $attributes);

        } else {
            return $product->get_matching_variation($attributes);
        }
    }
}


if ( ! function_exists( 'rex_feed_get_dynamic_price' ) ) {
    /**
     * gets conditioned price
     *
     * @param $key
     * @param $price
     * @return float|int
     */
    function rex_feed_get_dynamic_price( $rule, $price )
    {
        $is_premium = apply_filters( 'wpfm_is_premium', false );

        if( $is_premium ) {
            $price      = $price === '' ? 0 : $price;
            $expression = isset( $rule[ 'limit' ] ) ? $rule[ 'limit' ] : '';
            $operators  = preg_split( '([^\\+\\-*\\/\^])', trim( $expression ) );
            $operators  = array_values( array_filter( $operators ) );
            $numbers    = preg_split( '/[^0-9\%]/', trim( $expression ) );
            $numbers    = array_values( array_filter( $numbers ) );
            $i          = 0;

            foreach( $operators as $operator ) {
                switch( $operator ) {
                    case '+':
                        (float)$price += (float)rex_feed_get_percentage( $numbers[ $i++ ], $price );
                        break;
                    case '-':
                        (float)$price -= (float)rex_feed_get_percentage( $numbers[ $i++ ], $price );
                        break;
                    case '*':
                        (float)$price *= (float)rex_feed_get_percentage( $numbers[ $i++ ], $price );
                        break;
                    case '/':
                        (float)$price /= (float)rex_feed_get_percentage( $numbers[ $i++ ], $price );
                        break;
                    default:
                        break;
                }
            }
        }

        return $price == 0 ? '' : (float)$price;
    }
}


if ( ! function_exists( 'rex_feed_get_percentage' ) ) {
    /**
     * Gets percentage of total price to calculate dynamic price
     *
     * @param $number
     * @param $price
     * @return float|int
     */
    function rex_feed_get_percentage( $number, $price )
    {
        if( strpos( $number, '%' ) !== false ) {
            $number = str_replace( '', '%', $number );
            return (float)$price * ( (float)$number / 100 );
        }
        return (float)$number;
    }
}