<?php

namespace RexTheme\RexShoppingFeedCustom\EbayMip;
use SimpleXMLElement;

class EbayMipFeed extends \RexTheme\RexShoppingFeed\Feed
{

    /**
     * @var $product_type
     */
    protected $product_type;


    /**
     * @var $localization
     */
    protected $localization;


    protected function setProductType($type) {
        $this->product_type = $type;
    }

    /**
     * @param string $localization
     */
    public function localization($localization){
        $this->localization = (string)$localization;
    }


    /**
     * Adds items to feed
     */
    private function addItemsToFeedCSV(){

        if(count($this->items)){
            $this->items_row[] = array_keys(end($this->items)->nodes());
            foreach ($this->items as $item) {
                $row = array();
                foreach ($item->nodes() as $itemNode) {
                    if (is_array($itemNode)) {
                        foreach ($itemNode as $node) {
                            $row[] = str_replace(array("\r\n", "\n", "\r"), ' ', $node->get('value'));
                        }
                    } else {
                        $row[] = str_replace(array("\r\n", "\n", "\r"), ' ', $itemNode->get('value'));
                    }
                }
                $this->items_row[] = $row;
            }

            $str = '';
            foreach ($this->items_row as $fields) {
                $str .= implode("\t", $fields) . "\n";
            }
        }

        return $this->items_row;
    }


    /**
     * Generate CSV feed
     * @param bool $output
     * @return string
     */
    public function asCsv($output = false)
    {

        if (ob_get_contents()) ob_end_clean();
        $data = $this->addItemsToFeedCSV();
        if ($output) {
            die($data);
        }
        return $data;
    }

}
