'use strict'

var NCoreEmbedder = function(){
	this.iFrameId = null;
};



NCoreEmbedder.prototype.setElement = function(id){
	this.iFrameId = id;
};


NCoreEmbedder.prototype.getElement = function(){
	return this.iFrameId;
};

NCoreEmbedder.prototype.init = function(id)
{
	this.setElement(id);
	var encodedNCoreUrl = null;

	if(typeof URL === "function"){
		var query = window.location.href;
		var url = new URL(query);
		encodedNCoreUrl = url.searchParams.get("nCoreUrl");
	}
	else{
		var query = window.location.search.substring(1);
		var parameters = this.manualParsing(query);
		encodedNCoreUrl = parameters.nCoreUrl;
	}

	if(encodedNCoreUrl){
		var decodedNcoreUrl = this.decodeUrl(encodedNCoreUrl);

		decodedNcoreUrl = this.addGETParameters(decodedNcoreUrl);

		this.replaceSrc(decodedNcoreUrl);
	}
	else{
		var originalSrc = this.getSrc();

		var newUrl = this.addGETParameters(originalSrc);

		this.replaceSrc(newUrl);
	}
	
};


NCoreEmbedder.prototype.replaceSrc = function(src)
{
	var id = this.getElement();

	document.getElementById(id).src = src;
}


NCoreEmbedder.prototype.getSrc = function()
{
	var id = this.getElement();

	return document.getElementById(id).getAttribute('data-src');
}


NCoreEmbedder.prototype.manualParsing = function(query)
{
	var vars = query.split("&");
  	var query_string = {};
  	for (var i = 0; i < vars.length; i++) {
	    var pair = vars[i].split("=");
	    var key = decodeURIComponent(pair[0]);
	    var value = decodeURIComponent(pair[1]);
	    if (typeof query_string[key] === "undefined") {
	      query_string[key] = decodeURIComponent(value);
	    } else if (typeof query_string[key] === "string") {
	      var arr = [query_string[key], decodeURIComponent(value)];
	      query_string[key] = arr;
	    } else {
	      query_string[key].push(decodeURIComponent(value));
	    }
  	}
  	return query_string;
};


NCoreEmbedder.prototype.decodeUrl = function(url)
{	
	return atob(url);
};


NCoreEmbedder.prototype.getParameters = function(url)
{
	var getParameters = {};
	if(typeof URL === "function"){
		var query = url;
		var url = new URL(query);
		var entries = url.searchParams.entries();
	
		entries = Array.from(entries);

		for(var i = 0; i < entries.length; i++){
			var pair = entries[i];
			getParameters[pair[0]] = pair[1];
		}
	}
	else{
		var query = window.location.search.substring(1);
		if(query){
			getParameters = this.manualParsing(query);
		}
	}	
	return getParameters;
}

NCoreEmbedder.prototype.addGETParameters = function(url)
{
	var parameters = this.getParameters(window.location.href);

	var urlCopy = url;

	if(typeof URL === 'function'){
		var urlObj = new URL(urlCopy);

		for (var k in parameters) {
	        if (parameters.hasOwnProperty(k)) {
	           if(k == 'nCoreUrl'){
	           	continue;
	           }
	           urlObj.searchParams.append(k, parameters[k]);
	        }
    	}

    	urlCopy = urlObj.toString();
	}
	else{
		var noParams = false;

		for (var k in parameters) {
	        if (parameters.hasOwnProperty(k)) {
	           if(k == 'nCoreUrl'){
	           	continue;
	           }
	           if (urlCopy.indexOf('?') <= -1){
					urlCopy += '?';
					noParams = true;
	           }
	           if(noParams){
	           		urlCopy += k+"="+parameters[k];
	           		noParams = false;
	           }
	           else{
	           		urlCopy += "&"+k+"="+parameters[k];
	           }
	        }
    	}
	}

	return urlCopy;
}