<?php
    /*
    Plugin Name: nCorePlat
    Description: nCore Plat Plugin
    Version: 2.5.4
	Plugin URI: https://www.ncorehr.com/plugin/
    Author: nCore
    Author URI: https://www.ncorehr.com/
	Text Domain: ncoreplat
	Domain Path: /languages
	
    */
	
// Prevent direct file access
defined( 'ABSPATH' ) or exit;

// the core plugin
	define( 'NCORE_PLAT_VERSION', '2.5.4' );
	define( 'NCORE_PLAT_PLUGIN_DIR', __DIR__ . '/' );
	define( 'NCORE_PLAT_PLUGIN_URL', plugins_url( '/', __FILE__ ) );
	define( 'NCORE_PLAT_PLUGIN_FILE', __FILE__ );
	define( 'NCORE_PLAT_PLUGIN_BASENAME', dirname( plugin_basename( __FILE__ ) ) );
	define( 'NCORE_PLAT_PLUGIN_PATH', plugin_dir_path ( __FILE__ ) );

// backend
class ncore_plat_button {
 
    public function __construct () {
		add_action( 'init', array( $this, 'action_admin_init_ncore' ) );
    }
	
	function action_admin_init_ncore() {
		if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
			return;
		}
		if ( get_user_option('rich_editing') == 'true' ) {
			add_filter( 'mce_buttons_2', array( $this, 'ncoreplat_mce_button' ) );
			add_filter( 'mce_external_plugins', array( $this, 'ncoreplat_mce_plugin' ) );
		}		
	}
	
	function ncoreplat_mce_button( $buttons_ncore ) {
		// add a separation before our button, here our button's id is "mygallery_button"
		array_push( $buttons_ncore, "|", "ncoreplat" );
		return $buttons_ncore;
	}
	
	function ncoreplat_mce_plugin( $plugin_array ) {
		// this plugin file will work the magic of our button
		$plugin_array['ncoreplat'] = NCORE_PLAT_PLUGIN_URL . 'nCorePlatButton.js';
		
		add_filter( 'mce_external_languages', array( $this, 'wpse_44785_add_tinymce_lang') );
		
		return $plugin_array;
	}
	
	function wpse_44785_add_tinymce_lang($locales) {
		$locales ['ncoreplat'] = NCORE_PLAT_PLUGIN_PATH . 'lang-file.php';
		return $locales;
	}
}
$ncore_plat_button = new ncore_plat_button();




// traduzioni
add_action('plugins_loaded', 'ncoreplatInitTranslation');
function ncoreplatInitTranslation() {
	load_plugin_textdomain( 'ncoreplat', false, NCORE_PLAT_PLUGIN_BASENAME . '/languages/' );
}

function gtext($key = null) {
    global $t;
    $t = array(
		'category_title'	=> __( "nCore" , "ncoreplat" ),
		'button_title'		=> __( "nCore Plat" , "ncoreplat" ),
		'modal_title'		=> __( "nCore Plat Plugin" , "ncoreplat" ),
		'url_label'			=> __( "URL" , "ncoreplat" ),
		'url_html'			=> __( "Enter the nCore URL" , "ncoreplat" ),
		'required_field'	=> __( "(required field)" , "ncoreplat" ),
		'class_label'		=> __( "Class" , "ncoreplat" ),
		'class_html'		=> __( "Choose a class" , "ncoreplat" ),
		'width_label'		=> __( "Width" , "ncoreplat" ),
		'width_html'		=> __( "Enter a width" , "ncoreplat" ),
		//'height_label'	=> __( "Height" , "ncoreplat" ),
		//'height_html'		=> __( "Enter a height" , "ncoreplat" ),
		//'minheight_label'	=> __( "Min Height" , "ncoreplat" ),
		//'minheight_html'	=> __( "Enter a minimum height" , "ncoreplat" ),	
    );
	return is_null($key) ? $t : isset( $t[$key] ) ? $t[$key] : false; 
}




// frontend
class ncoreplat_script {

    public function __construct () {
		add_action( 'the_posts', array( $this, 'check_shortcode_ncoreplat' ) );
    }

	function check_shortcode_ncoreplat($posts) {
		if ( empty($posts) )
			return $posts; 
		// false because we have to search through the posts first
		$found = false;
		// search through each post
		foreach ($posts as $post) {
			// check the post content for the short code
			if ( stripos($post->post_content, 'ncoreplat') )
				// we have found a post with the short code
				$found = true;
				// stop the search
				break;
			}
		// caricare eventuali script o css del plugin
		if ($found){
			//wp_enqueue_style( 'nCorePlatsCss', NCORE_PLAT_PLUGIN_URL . "inc/nCorePlat.css", array(), NCORE_PLAT_VERSION);
			wp_enqueue_script( 'nCoreEmbedder', NCORE_PLAT_PLUGIN_URL . "inc/ncore-embedder.js", array('jquery'), NCORE_PLAT_VERSION);
			wp_enqueue_script( 'iFrameResizer', "https://cdnjs.cloudflare.com/ajax/libs/iframe-resizer/3.6.3/iframeResizer.min.js", array('jquery'), NCORE_PLAT_VERSION);
		}
		return $posts;
	}		
	
}
$ncoreplat_script = new ncoreplat_script();




// shortcode
class ncoreplat_shortcode {
 
    public function __construct () {
		add_shortcode( 'ncoreplat', array( $this, 'nCorePlat_func' ));
    }
	
    // Render the shortcode
    // @param array $atts shortcode attributes
	
	public function nCorePlat_func($atts) {
		$a = shortcode_atts( array(
			'classe'		=> 'ncore',
			'link'			=> '',
			'width'			=> '100%',
			//'height'		=> '100%',
			//'minheight'	=> '100vh'
		), $atts );
		//return '<iframe id="ncoreembedder" class="' . esc_attr($a['class']) . '" src="' . esc_attr($a['link']) . '" width="' . esc_attr($a['width']) . '" height="' . esc_attr($a['height']) . '" style="display:block; min-height:' . esc_attr($a['minheight']) . ';" allow="camera *; microphone *;" frameborder="0" border="0" allowtransparency="true"></iframe>'
		return '<iframe id="ncoreembedder" class="' . esc_attr($a['classe']) . '" data-src="' . esc_attr($a['link']) . '" width="' . esc_attr($a['width']) . '" height="100%" style="display:block; min-height:100vh;" allow="camera *; microphone *;" frameborder="0" border="0" allowtransparency="true"></iframe>
		<script>
			var firstLoad = true;
			var embedder = new NCoreEmbedder();
			embedder.init("ncoreembedder");
			
			jQuery("#ncoreembedder").on("load", function() { 		
				jQuery(this).iFrameResize({
					heightCalculationMethod: "bodyScroll",
					scrolling: true,
					checkOrigin: [
						"https://app.ncoreplat.com",
						"https://tapp.ncoreplat.com",
						"https://dapp.ncoreplat.com"
					]
				});
				if(!firstLoad){
					jQuery(this).get(0).scrollIntoView();	
				}
				else{
					firstLoad = false;
				}
			});
		</script>';
	}
	
}
$nCorePlat_shortcode = new nCorePlat_shortcode();




// visual composer
class ncore_plat_vcomposer {
	
	public function __construct () {	
		add_action( 'vc_before_init', array( $this, 'ncore_integrateWithVC' ));
	}
	
	public function ncore_integrateWithVC() {
		
		vc_map( array(
			"name" => gtext('button_title'),
			"base" => "ncoreplat",
			"class" => "",
			"icon" => "ncore_icon",
			"category" => gtext('category_title'),
			"description" => gtext('modal_title'),
			"show_settings_on_create" => true,
			"is_container" => false,
			"admin_enqueue_css" => array( plugin_dir_url( __FILE__ ) . 'vc_extend/vc_admin.css' ),
			"params" => array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "hidden_param",
					"heading" => gtext('url_label'),
					"param_name" => "link",
					"value" => '',
					"description" => gtext('url_html') . " " . gtext('required_field'), // Inserisci l'URL di nCore (campo obbligatorio)
					"admin_label" => true,
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => gtext('class_label'),
					"param_name" => "classe",	
					"value" => 'ncore',
					"description" => gtext('class_html'), // Scegli una classe
					"admin_label" => false,
					"edit_field_class" => "vc_col-xs-6",
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "hidden_param",
					"heading" => gtext('width_label'),
					"param_name" => "width",
					"value" => '100%',
					"description" => gtext('width_html'), // Inserisci una larghezza
					"admin_label" => false,
					"edit_field_class" => "vc_col-xs-6"
				),
				/*array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "hidden_param",
					"heading" => gtext('height_label'),
					"param_name" => "height",
					"value" => '100%',
					"description" => gtext('height_html'), // Inserisci un'altezza
					"admin_label" => false,
					"edit_field_class" => "vc_col-xs-6"
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "hidden_param",
					"heading" => gtext('minheight_label'),
					"param_name" => "minheight",
					"value" => '100vh',
					"description" => gtext('minheight_html'), // Inserisci un'altezza minima
					"admin_label" => false,
					"edit_field_class" => "vc_col-xs-6"
				)*/
			)
		) );
	}
}
$ncore_plat_vcomposer = new ncore_plat_vcomposer();




// update
require_once NCORE_PLAT_PLUGIN_DIR . 'plugin-update-checker/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'https://www.ncorehr.com/download/update/plugin.json',
	__FILE__, //Full path to the main plugin file or functions.php.
	'nCorePlat'
);

?>