(function() {
	tinymce.create('tinymce.plugins.ncoreplat', {
		init : function(editor, url) {
			editor.addButton('ncoreplat', {
				text: editor.getLang('extrastrings.categorytitle'),
				icon: false,
				title : editor.getLang('extrastrings.buttontitle'),
				image : url + '/img/ncore-ico.png',
				onclick: function () {
					editor.windowManager.open({
						title: editor.getLang('extrastrings.modaltitle'),
						body: [
							{
								type: 'textbox',
								name: 'link',
								label: editor.getLang('extrastrings.urllabel'),
								value: '',
							},
							{
								type   : 'container',
								name   : 'container',
								html   : '<p>' + editor.getLang('extrastrings.urlhtml') + ' ' + editor.getLang('extrastrings.requiredfield') + '</p>'
							},
							{
								type: 'textbox',
								name: 'classe',
								label: editor.getLang('extrastrings.classlabel'),
								value: 'ncore',
							},
							{
								type   : 'container',
								name   : 'container',
								html   : '<p>' + editor.getLang('extrastrings.classhtml') + '</p>'
							},
							{
								type: 'textbox',
								name: 'width',
								label: editor.getLang('extrastrings.widthlabel'),
								value: '100%',
							},
							{
								type   : 'container',
								name   : 'container',
								html   : '<p>' + editor.getLang('extrastrings.widthhtml') + '</p>'
							},
							/*{
								type: 'textbox',
								name: 'height',
								label: editor.getLang('extrastrings.heightlabel'),
								value: '100%',
							},
							{
								type   : 'container',
								name   : 'container',
								html   : '<p>' + editor.getLang('extrastrings.heighthtml') + '</p>'
							},
							{
								type: 'textbox',
								name: 'minheight',
								label: editor.getLang('extrastrings.minheightlabel'),
								value: '100vh',
							},
							{
								type   : 'container',
								name   : 'container',
								html   : '<p>' + editor.getLang('extrastrings.minheighthtml') + '</p>'
							},*/
						],
						onsubmit: function(e) {
							target = '';
							if(e.data.blank === true) {
								target += 'newtab="on"';
							}
							var shortcode = '[ncoreplat';
							var options = {
								'classe':		e.data.classe,
								'link':			e.data.link,
								'width':		e.data.width,
								//'height':		e.data.height,
								//'minheight':	e.data.minheight,
							};
							//editor.insertContent('[ncoreplat  class="' + e.data.class + '" link="' + e.data.link + '" width="' + e.data.width + '" height="' + e.data.height + '" minheight="' + e.data.minheight + '"]');
							for( var index in options) {
								// attaches the attribute to the shortcode only if it's different from the default value
								value = options[index];
								//if ( value === e.data.blank )
									shortcode += ' ' + index + '="' + value + '"';
							}		
							shortcode += ']';
							editor.insertContent( shortcode );
						}
				   });
			   }
		   });
		},
		createControl : function(n, cm) {
			return null;
		},
		getInfo : function() {
			return {
				longname : "nCorePlat",
				author : 'Macro Web Media',
				authorurl : 'https://www.macrowebmedia.it',
				infourl : 'https://www.ncorehr.com',
				version : tinymce.majorVersion + "." + tinymce.minorVersion
			};
		}
		
		
	});
	
	tinymce.PluginManager.add('ncoreplat', tinymce.plugins.ncoreplat);
	
})();