<?php

/**
 * Copyright (c) HeidiPay.
 */

namespace HeidiPay\Classes;

class Requester {

    /** @var string */
    private $url = '';

    /** @var array */
    private $headers = array(
        'Content-Type'              => 'application/json',
        'UserAgent'                 => 'woocommerce',
        'X-Client-Platform'         => 'Woocommerce',
        'X-Client-Platform-Version' => WC_VERSION,
        'X-Client-Module'           => 'heidi-woocommerce'
    );

    /**
     * @param string $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param string $key
     * @param string $value
     */
    public function addHeader($key, $value)
    {
        $this->headers[$key] = $value;
    }

    /**
     * @param string[] $headers
     */
    public function setHeaders(array $headers)
    {
        $this->headers = $headers;
    }

    /**
     * @param array $body
     * @return array
     */
    public function post($body)
    {
        return $this->request(true, $body);
    }

    /**
     * @return array
     */
    public function get()
    {
        return $this->request();
    }

    /**
     * Request
     * @param bool $methodPost 
     * @param array $body 
     * @return array 
     */
    public function request($methodPost = false, $body = [])
    {
        $headers = [];
        foreach ($this->headers as $key => $value) {
            $headers[] = $key . ':' . $value;
        }

        $ch = curl_init($this->url);
        curl_setopt($ch, CURLOPT_POST, $methodPost);
        if ($methodPost) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
        }
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $contents = curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return compact('contents', 'code');
    }
}
