<?php
	class TDWUR_DRAW_ATTENTION {
	public $parent;

	function __construct( $parent ) {
		$this->parent = $parent;

		add_filter( 'redux/options/webmaster_user_role_config/sections', array( $this, 'settings_section' ) );

		add_action( 'admin_menu', array( $this, 'admin_menu' ), 999 );
	}

	function is_active() {
		return ( class_exists( 'bpfwpInit' ) );
	}

	function settings_section( $sections ) {
		if ( !$this->is_active() ) return $sections;

		$sections[] = array(
			'icon'      => 'wp-menu-image tools',
			'title'     => __('Draw Attention', 'webmaster-user-role'),
			'fields'    => array(
				array(
					'id'        => 'webmaster_admin_menu_draw_attention',
					'type'      => 'checkbox',
					'title'     => __('Draw Attention', 'webmaster-user-role'),
					'subtitle'  => __('Webmaster (Admin) users can', 'webmaster-user-role'),

					'options'   => array(
						'draw_attention_menu' => __('Add Draw Attention Images', 'webmaster-user-role'),
					),

					'default'   => array(
						'draw_attention_menu' => '0',
					)
				),
			)
		);

		return $sections;
	}

	function admin_menu() {
		if ( !$this->is_active() ) return;
		if ( !TD_WebmasterUserRole::current_user_is_webmaster() ) return;

		$webmaster_user_role_config = TD_WebmasterUserRole::get_config();

		if ( ( is_array( $webmaster_user_role_config ) && isset( $webmaster_user_role_config['webmaster_admin_menu_draw_attention']['draw_attention_menu'] ) && !$webmaster_user_role_config['webmaster_admin_menu_draw_attention']['draw_attention_menu'] ) ) {
			remove_menu_page( 'edit.php?post_type=da_image' );
		}
	}
}