<?php
/*
 * Module for Custom Post Type UI
 */
	
class TDWUR_GoPricing {
	public $parent;
	private $section;
	
	function __construct( $parent ) {
		$this->parent = $parent;
		
		add_filter( 'redux/options/webmaster_user_role_config/sections', array( $this, 'settings_section' ) );
		add_action('admin_menu', array( $this, 'admin_menu' ), 102 );
	}
	
	function is_active() {
		return ( class_exists( 'GW_GoPricing' ) );
	}
	
	function settings_section( $sections ) {
		if ( !$this->is_active() ) return $sections;

		$sections[] = $this->section = array(
			'icon'      => 'wp-menu-image dashicons-admin-plugins',
			'title'     => __('Go Pricing', 'webmaster-user-role'),
			'fields'    => array(
				array(
					'id'        => 'webmaster_admin_menu_gopricing',
					'type'      => 'checkbox',
					'title'     => __('Go Pricing Capabilities', 'webmaster-user-role'),
					'subtitle'  => __('Webmaster (Admin) users can', 'webmaster-user-role'),

					'options'   => array(
						'gopricing_menu' => __('Access Go Pricing Menu', 'webmaster-user-role'),
					),
					
					'default'   => array(
						'view_wf_widget' => '0',						
					)
				),
			)
		);
		
		return $sections;
	}//end settings_section function
	
	function admin_menu() {
		global $webmaster_user_role_config;
		if ( !is_array( $webmaster_user_role_config ) || !TD_WebmasterUserRole::current_user_is_webmaster() ) {
			return;
		}

		if ( empty ( $webmaster_user_role_config['webmaster_admin_menu_gopricing']['gopricing_menu'] ) ) {
			remove_menu_page( 'go-pricing' );
		}
	}
	
} //end class TDWUR_GoPricing
?>