<?php
class TDWUR_HTML_Snippets {
	public $parent;

	function __construct( $parent ) {
		$this->parent = $parent;

		add_filter( 'redux/options/webmaster_user_role_config/sections', array( $this, 'settings_section' ) );
		
		add_action( 'admin_menu', array( $this, 'admin_menu' ), 999 );
	}

	function is_active() {
		return ( defined( 'XYZ_INSERT_HTML_PLUGIN_FILE' ) );
	}

	function settings_section( $sections ) {
		if ( !$this->is_active() ) return $sections;

		$sections[] = array(
			'icon'      => 'dashicons dashicons-editor-code',
			'title'     => __('Insert HTML Snippets', 'webmaster-user-role'),
			'fields'    => array(
				array(
					'id'        => 'webmaster_admin_menu_html_snippets',
					'type'      => 'checkbox',
					'title'     => __('Insert HTML Snippets', 'webmaster-user-role'),
					'subtitle'  => __('Webmaster (Admin) users can', 'webmaster-user-role'),

					'options'   => array(
						'html_snippets_menu' => __('Manage HTML Snippets', 'webmaster-user-role'),
					),
					
					'default'   => array(
						'html_snippets_menu' => '0',
					)
				),
			)
		);

		return $sections;
	}

	function admin_menu() {
		if ( !$this->is_active() ) return;
		if ( !TD_WebmasterUserRole::current_user_is_webmaster() ) return;

		$webmaster_user_role_config = TD_WebmasterUserRole::get_config();
		if ( ! ( is_array( $webmaster_user_role_config ) && isset( $webmaster_user_role_config['webmaster_admin_menu_html_snippets']['html_snippets_menu'] ) && !empty( $webmaster_user_role_config['webmaster_admin_menu_html_snippets']['html_snippets_menu'] ) ) ) {
			remove_menu_page( 'insert-html-snippet-manage' );
		}
	}
}