<?php
class TDWUR_Jetpack {
	public $parent;

	function __construct( $parent ) {
		$this->parent = $parent;

		add_filter( 'redux/options/webmaster_user_role_config/sections', array( $this, 'settings_section' ) );
	}

	function is_active() {
		return ( class_exists( 'Jetpack' ) );
	}

	function settings_section( $sections ) {
		if ( !$this->is_active() ) return $sections;

		$sections[] = array(
			// 'icon'      => '',
			'title'     => __('Jetpack', 'webmaster-user-role'),
			'fields'    => array(
				array(
					'id'        => 'webmaster_caps_jetpack_caps',
					'type'      => 'checkbox',
					'title'     => __('Jetpack', 'webmaster-user-role'),
					'subtitle'  => __('Webmaster (Admin) users can', 'webmaster-user-role'),

					'options'   => array(
						'view_stats' => __('View Stats', 'webmaster-user-role'),
					),
					
					'default'   => array(
						'view_stats' => '0',
					)
				),
			)
		);

		return $sections;
	}

}