<?php
class TDWUR_OPTIN {
	public $parent;

	function __construct( $parent ) {
		$this->parent = $parent;

		add_filter( 'redux/options/webmaster_user_role_config/sections', array( $this, 'settings_section' ) );

		add_action( 'admin_menu', array( $this, 'admin_menu' ), 999 );
	}

	function is_active() {
		return ( function_exists( 'optin_monster_tag' ) );
	}

	function settings_section( $sections ) {
		if ( !$this->is_active() ) return $sections;

		$sections[] = array(
			'icon'      => 'wp-menu-image tools',
			'title'     => __('OptinMonster', 'webmaster-user-role'),
			'fields'    => array(
				array(
					'id'        => 'webmaster_admin_menu_optin',
					'type'      => 'checkbox',
					'title'     => __('OptinMonster', 'webmaster-user-role'),
					'subtitle'  => __('Webmaster (Admin) users can', 'webmaster-user-role'),

					'options'   => array(
						'optin_menu' => __('Manage OptinMonster', 'webmaster-user-role'),
					),

					'default'   => array(
						'optin_menu' => '0',
					)
				),
			)
		);

		return $sections;
	}

	function admin_menu() {
		if ( !$this->is_active() ) return;
		if ( !TD_WebmasterUserRole::current_user_is_webmaster() ) return;

		$webmaster_user_role_config = TD_WebmasterUserRole::get_config();
		
		if ( ( is_array( $webmaster_user_role_config ) && isset( $webmaster_user_role_config['webmaster_admin_menu_optin']['optin_menu'] ) && !$webmaster_user_role_config['webmaster_admin_menu_optin']['optin_menu'] ) ) {
			remove_menu_page( 'optin-monster-api-welcome' );
			remove_menu_page( 'optin-monster-api-settings' );
		}
	}
}