<?php
class TDWUR_Redirection {
	public $parent;
	public $caps;
	private $section;

	function __construct() {
		add_filter( 'redux/options/webmaster_user_role_config/sections', array( $this, 'settings_section' ) );

		// add_filter( 'td_webmaster_capabilities', array( $this, 'default_capabilities' ), 2 );
		add_filter( 'redirection_role', array( $this, 'redirection_role' ) );
	}

	function is_active() {
		return class_exists( 'Redirection_Admin' );
	}

	function settings_section( $sections ) {
		if ( !$this->is_active() ) return $sections;

		$this->section = array(
			'icon'      => 'wp-menu-image dashicons dashicons-list-view',
			'title'     => __( 'Redirection', 'webmaster-user-role' ),
			'fields'    => array(
				array(
					'id'        => 'redirection_settings',
					'type'      => 'checkbox',
					'title'     => __( 'Manage Redirection', 'redux-framework-demo' ),
					'subtitle'  => __( 'Webmaster users can', 'redux-framework-demo' ),

					'options'   => array(
						'manage_redirections' => 'Mange Redirection',
					),

					'default'   => array(
						'manage_redirections' => '0',
					)
				),
			)
		);

		$sections[] = $this->section;

		return $sections;
	}

	function redirection_role( $redirection_role ) {
		if ( !TD_WebmasterUserRole::current_user_is_webmaster() ) return $redirection_role;

		global $webmaster_user_role_config;
		if ( !is_array( $webmaster_user_role_config ) ) return $redirection_role;

		if ( !empty( $webmaster_user_role_config['redirection_settings']['manage_redirections'] ) ) return 'webmaster';

		return $redirection_role;
	}

}
new TDWUR_Redirection();