<?php
/*
 * Module for Custom Post Type UI
 */
	
class TDWUR_RevolutionSlider {
	public $parent;
	private $section;
	
	function __construct( $parent ) {
		$this->parent = $parent;
		
		add_filter( 'redux/options/webmaster_user_role_config/sections', array( $this, 'settings_section' ) );
		add_action('admin_menu', array( $this, 'admin_menu' ), 102 );
	}
	
	function is_active() {
		return ( class_exists( 'UniteBaseFrontClassRev' ) );
	}
	
	function settings_section( $sections ) {
		if ( !$this->is_active() ) return $sections;

		$sections[] = $this->section = array(
			'icon'      => 'wp-menu-image dashicons-admin-plugins',
			'title'     => __('Revolution Slider', 'webmaster-user-role'),
			'fields'    => array(
				array(
					'id'        => 'webmaster_admin_menu_revslider',
					'type'      => 'checkbox',
					'title'     => __('Revolution Slider Capabilities', 'webmaster-user-role'),
					'subtitle'  => __('Webmaster (Admin) users can', 'webmaster-user-role'),

					'options'   => array(
						'revslider_menu' => __('Access Revolution Slider Menu', 'webmaster-user-role'),
					),
					
					'default'   => array(
						'view_wf_widget' => '0',						
					)
				),
			)
		);
		
		return $sections;
	}//end settings_section function
	
	function admin_menu() {
		global $webmaster_user_role_config;
		if ( !is_array( $webmaster_user_role_config ) || !TD_WebmasterUserRole::current_user_is_webmaster() ) {
			return;
		}

		if ( empty ( $webmaster_user_role_config['webmaster_admin_menu_revslider']['revslider_menu'] ) ) {
			remove_menu_page( 'revslider' );
			remove_menu_page( 'themepunch-google-fonts' );
		}
	}
	
} //end class TDWUR_RevolutionSlider
?>