<?php
class TDWUR_SIContactForm {
	public $parent;

	function __construct( $parent ) {
		$this->parent = $parent;

		add_filter( 'redux/options/webmaster_user_role_config/sections', array( $this, 'settings_section' ) );
		
		add_action( 'init', array( $this, 'init' ) );
	}

	function is_active() {
		return ( class_exists( 'FSCF_Util' ) );
	}

	function settings_section( $sections ) {
		if ( !$this->is_active() ) return $sections;

		$sections[] = array(
			'icon'      => 'dashicons dashicons-feedback',
			'title'     => __('Fast Secure Contact Form', 'webmaster-user-role'),
			'fields'    => array(
				array(
					'id'        => 'webmaster_admin_menu_si_contact_form',
					'type'      => 'checkbox',
					'title'     => __('Fast Secure Contact Form', 'webmaster-user-role'),
					'subtitle'  => __('Webmaster (Admin) users can', 'webmaster-user-role'),

					'options'   => array(
						'si_contact_form_menu' => __('Manage Fast Secure Contact Form', 'webmaster-user-role'),
					),
					
					'default'   => array(
						'si_contact_form_menu' => '0',
					)
				),
			)
		);

		return $sections;
	}

	function init() {
		if ( !$this->is_active() ) return;
		if ( !TD_WebmasterUserRole::current_user_is_webmaster() ) return;

		$webmaster_user_role_config = TD_WebmasterUserRole::get_config();
		if ( ! ( is_array( $webmaster_user_role_config ) && isset( $webmaster_user_role_config['webmaster_admin_menu_si_contact_form']['si_contact_form_menu'] ) && !empty( $webmaster_user_role_config['webmaster_admin_menu_si_contact_form']['si_contact_form_menu'] ) ) ) {
			remove_action( 'admin_menu', 'FSCF_Options::register_options_page' );
		}
	}
}