<?php
class TDWUR_SIMPLE_CSS {
	public $parent;

	function __construct( $parent ) {
		$this->parent = $parent;

		add_filter( 'redux/options/webmaster_user_role_config/sections', array( $this, 'settings_section' ) );

		add_action( 'admin_menu', array( $this, 'admin_menu' ), 999 );
	}

	function is_active() {
		return ( defined( 'SCCSS_FILE' ) );
	}

	function settings_section( $sections ) {
		if ( !$this->is_active() ) return $sections;

		$sections[] = array(
			'icon'      => 'wp-menu-image tools',
			'title'     => __('Simple Custom CSS', 'webmaster-user-role'),
			'fields'    => array(
				array(
					'id'        => 'webmaster_admin_menu_simple_css',
					'type'      => 'checkbox',
					'title'     => __('Simple Custom CSS', 'webmaster-user-role'),
					'subtitle'  => __('Webmaster (Admin) users can', 'webmaster-user-role'),

					'options'   => array(
						'simple_css_menu' => __('Add CSS', 'webmaster-user-role'),
					),

					'default'   => array(
						'simple_css_menu' => '0',
					)
				),
			)
		);

		return $sections;
	}

	function admin_menu() {
		if ( !$this->is_active() ) return;
		if ( !TD_WebmasterUserRole::current_user_is_webmaster() ) return;

		$webmaster_user_role_config = TD_WebmasterUserRole::get_config();
		if ( ( is_array( $webmaster_user_role_config ) && isset( $webmaster_user_role_config['webmaster_admin_menu_simple_css']['simple_css_menu'] ) && !$webmaster_user_role_config['webmaster_admin_menu_simple_css']['simple_css_menu'] ) ) {
			remove_submenu_page( 'themes.php', 'simple-custom-css.php' );
		}
	}
}