<?php
if( ! class_exists('BeRocket_AAPF_paid_checkbox_search') ) {
    class BeRocket_AAPF_paid_checkbox_search {
        function __construct() {
            add_action('braapf_single_filter_additional', array(__CLASS__, 'filter_option'), 250, 2);
            add_action('BeRocket_AAPF_template_full_content', array(__CLASS__, 'search_input'), 2000, 3);
            add_filter('berocket_aapf_query_var_title_filter', array($this, 'query_var_title'), 10, 3);
        }
        function query_var_title($set_query_var_title, $instance, $br_options) {
            $set_query_var_title['checkbox_search_value'] = ! empty($instance['checkbox_search_value']);
            $set_query_var_title['checkbox_search_value_placeholder'] = (empty($instance['checkbox_search_value_placeholder']) ? __('Search', 'BeRocket_AJAX_domain') : $instance['checkbox_search_value_placeholder']);
            return $set_query_var_title;
        }
        static function search_input($template_content, $terms, $berocket_query_var_title) {
            if( $berocket_query_var_title['new_template'] == 'checkbox' && ! empty($berocket_query_var_title['checkbox_search_value']) ) {
                $template_content['template']['content']['filter']['content'] = array_merge(array(
                    'search_box' => array(
                        'type' => 'tag',
                        'tag'  => 'div',
                        'attributes' => array(
                            'class' => array(
                                'bapf_ckbox_search'
                            )
                        ),
                        'content' => array(
                            'search_input' => array(
                                'type' => 'tag_open',
                                'tag'  => 'input',
                                'attributes' => array(
                                    'placeholder' => esc_html($berocket_query_var_title['checkbox_search_value_placeholder'])
                                )
                            )
                        )
                    )
                ), $template_content['template']['content']['filter']['content']);
            }
            return $template_content;
        }
        static function filter_option ($settings_name, $braapf_filter_settings){
            echo '<div class="braapf_attribute_setup_flex braapf_show_checkbox_search_value">';
                echo '<div class="braapf_half_select_full">';
                    $checkbox_search_value = br_get_value_from_array($braapf_filter_settings, 'checkbox_search_value', '0');
                    echo '<p>';
                        echo '<input id="braapf_show_checkbox_search_value" type="checkbox" name="' . $settings_name . '[checkbox_search_value]"' . ( empty($checkbox_search_value) ? '' : ' checked' ) . ' value="1">';
                        echo '<label for="braapf_show_checkbox_search_value">'.__('Checkbox Search Input Field', 'BeRocket_AJAX_domain').'</label>';
                    echo '</p>';
                echo '</div>';
                echo '<div class="braapf_show_checkbox_search_value_placeholder braapf_half_select_full">';
                    $checkbox_search_value_placeholder = br_get_value_from_array($braapf_filter_settings, 'checkbox_search_value_placeholder', __('Search', 'BeRocket_AJAX_domain'));
                    echo '<p>';
                        echo '<label for="braapf_show_checkbox_search_value_placeholder">'.__('Checkbox Search Input Field', 'BeRocket_AJAX_domain').'</label>';
                        echo '<input id="braapf_show_checkbox_search_value_placeholder" type="text" name="' . $settings_name . '[checkbox_search_value_placeholder]" value="' . esc_html($checkbox_search_value_placeholder) . '">';
                    echo '</p>';
                echo '</div>';
            echo '</div>';
            ?>
            <script>
                jQuery(document).ready(function() {
                    berocket_show_element('.braapf_show_checkbox_search_value', '{.braapf_widget_type input[type=radio]} == "filter" && (!braapf_current_template! == "checkbox")');
                    berocket_show_element('.braapf_show_checkbox_search_value_placeholder', '{#braapf_show_checkbox_search_value} == true');
                });
            </script>
            <?php
        }
    }
    new BeRocket_AAPF_paid_checkbox_search();
}