const HeylightPaymentMethod = () => {
	const settings = wc.wcSettings.getSetting( 'heylight' + '_data', {} );
	const { dispatch } = wp.data
	const { createElement, useEffect } = wp.element;
	const { registerPaymentMethod } = wc.wcBlocksRegistry;
	const { decodeEntities } = wp.htmlEntities;

	const Content = ( { eventRegistration, emitResponse } ) => {
		const { onCheckoutFail } = eventRegistration;
		const { noticeContexts } = emitResponse;
		useEffect( () => {
			const unsubscribe = onCheckoutFail( async ( { processingResponse } ) => {
				var error = processingResponse?.paymentDetails?.message;
				error && dispatch('core/notices').createErrorNotice(error, {
					isDismissible: true,
					id: 'heylight-error',
					context: noticeContexts.CHECKOUT
				});
			} );
			return () => {
				unsubscribe();
			};
		}, [ onCheckoutFail ] );
		return decodeEntities( settings.description || '' );
	};

	const options = {
		name: 'heylight',
		label: createElement('div', {}, createElement('img', { src: settings.icon }), createElement('br'), settings.title),
		ariaLabel: settings.title,
		content: Object( createElement )( Content, null ),
		edit: createElement('div', {}, settings.description),
		canMakePayment: () => settings.available,
		supports: {
			features: settings.supports,
		},
		placeOrderButtonLabel: settings.button,
	};
	registerPaymentMethod( options );
}
HeylightPaymentMethod();