<?php 
/**
 * Copyright (c) HeidiPay.
 */

namespace HeidiPay\Classes;

use Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry;
use Automattic\WooCommerce\Utilities\FeaturesUtil;
use HeidiPay\Controllers\BlocksGateway;

class Blocks {

    /** @var Blocks */
	private static $instance;

    /**
     * Register post type
     * @return void 
     */
    public static function getInstance()
    {
        if (null === self::$instance) {
			self::$instance = new self();
		}
		return self::$instance;
    }
    
    /**
     * Constructor.
     * @return void
     */
    public function __construct()
    {
        add_action('before_woocommerce_init', [$this, 'declareCompatibility']);
        add_action('woocommerce_blocks_loaded', [$this, 'loadBlocks']);
    }

    /**
     * Declare compatibility
     * @return void 
     */
    public function declareCompatibility()
    {
        if (! class_exists( 'Automattic\WooCommerce\Utilities\FeaturesUtil' )) {
            return;
        }
        FeaturesUtil::declare_compatibility(
            'cart_checkout_blocks', 
            WP_PLUGIN_DIR.'/woocommerce-heylight-plugin/woocommerce-heidipay.php',
            true
        );
        // Next block todo: product_block_editor (now it's a beta version)
    }

    /**
     * Load blocks
     * @return void 
     */
    public function loadBlocks()
    {
        if (! class_exists( 'Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) {
            return;
        }
        add_action(
            'woocommerce_blocks_payment_method_type_registration',
            function( PaymentMethodRegistry $payment_method_registry ) {
                $payment_method_registry->register( new BlocksGateway );
            }
        );
    }
}