<?php

/**
 * Copyright (c) HeidiPay.
 */

namespace HeidiPay\Classes;

class Notice {

    /** @var Notice $instance */
    protected static $instance;

    /**
     * Get instance
     * @return Notice 
     */
    public static function getInstance()
    {
        if (empty(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Add Error
     * @param string $message
     * @return void
     */
    public function addError(string $message)
    {
        $this->notice($message, 'error');
    }

    /**
     * Add Success
     * @param string $message
     * @return void
     */
    public function addSuccess(string $message)
    {
        $this->notice($message, 'success');
    }

    /**
     * Add Info
     * @param string $message
     * @return void
     */
    public function addInfo(string $message)
    {
        $this->notice($message, 'notice');
    }

    /**
     * Notice
     * @param string $message
     * @param string $type (success, error, notice)
     * @return void
     */
    protected function notice($message, $type)
    {
        if (! wc_has_notice($message, $type)) {
            wc_add_notice($message, $type);
        }
    }
}