<?php 

namespace HeidiPay\Controllers;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

class BlocksGateway extends AbstractPaymentMethodType {

    private $gateway;

    /** @var string $name */
    protected $name = 'heylight';

    /**
     * Initialize
     * @return void 
     */
    public function initialize()
    {
        $this->gateway = new Gateway();
        $this->gateway->init_settings();
        $this->settings = $this->gateway->settings;
    }

    /**
     * Is active
     * @return boolean
     */
    public function is_active()
    {
        return $this->gateway->is_available();
    }

    /**
     * Get payment method script handles
     * @return void 
     */
    public function get_payment_method_script_handles()
    {
        $pluginDirectory = realpath(dirname(__FILE__).'/../');
        $pluginUrl = plugin_dir_url($pluginDirectory);
        $blocksUrl = $pluginUrl.'assets/js/';
        wp_register_script(
            'heylight-blocks-integration',
            $blocksUrl.'blocks.js',
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
                'wp-i18n',
            ],
            null,
            true
        );
        if( function_exists( 'wp_set_script_translations' ) ) {            
            wp_set_script_translations( 'heylight-blocks-integration');
        }
        return [ 'heylight-blocks-integration' ];
    }

    /**
     * Get payment method data
     * @return array 
     */
    public function get_payment_method_data()
    {
        return [
            'title' => $this->gateway->title,
			'description' => $this->gateway->description,
			'supports' => $this->gateway->supports,
            'icon' => $this->gateway->icon,
            'available' => $this->gateway->is_available(),
            'button' => __('Procedi a HeyLight', 'heylight')
        ];
    }

}