<?php
/*
Plugin Name: HeyLight
Description: Illumina le tue vendite con il pagamento a rate: dilazione e finanziamento digitale..
Author: HeyLight
Version: 2.7.1
Author URI: https://www.heidipay.com/
Text Domain: heylight
*/

/**
 * Copyright (c) HeidiPay.
 */

use HeidiPay\Classes\Filter;
use HeidiPay\Classes\Widget;
use HeidiPay\Classes\Blocks;
use HeidiPay\Controllers\Webhook;

if (!defined('ABSPATH')) {
	exit;
}

class WC_HeyLight {

	/**
	 * @var WC_HeyLight
	 */
	private static $instance;

	/**
	 * Constructor.
	 * @return void 
	 */
	public function __construct()
	{
		add_action('plugins_loaded', [$this, 'init']);
	}

	/**
	 * Init
	 * @return void
	 */
	public function init()
	{
		if (!class_exists('WC_Payment_Gateway')) {
			return;
		}

		require_once dirname(__FILE__) . '/vendor/autoload.php';
		define('HEIDIPAY_ISO3_COUNTRIES', include plugin_basename('/iso3.php'));
		add_filter('woocommerce_payment_gateways', [$this, 'add_gateways']);
		add_filter('plugin_action_links_' . plugin_basename(__FILE__), [$this, 'plugin_action_links']);

		/** Test if WooCommerce is active (including network activated). */
		$plugin_path = trailingslashit(WP_PLUGIN_DIR) . 'woocommerce/woocommerce.php';
		if (in_array($plugin_path, wp_get_active_and_valid_plugins()) || in_array($plugin_path, wp_get_active_network_plugins())) {
			Widget::getInstance();
			Filter::getInstance();
			Webhook::getInstance();
			Blocks::getInstance();
		}
	}

	/**
	 * Get items permissions check
	 * @param WP_REST_Request $request
	 * @return bool
	 */
	public function get_items_permissions_check($request)
	{
		return true;
	}

	/**
	 * Add gateway
	 * @param array $methods 
	 * @return array
	 */
	public function add_gateways($methods)
	{
		// Gateway always needs to be registered otherwise success/failure callbacks won't work
		$methods[] = '\\HeidiPay\\Controllers\\Gateway';

		// TODO carefully add cart threshold such that redirects don't break
		return $methods;
	}

	/**
	 * Plugin action links
	 * @param array $links
	 * @return array
	 */
	public function plugin_action_links($links)
	{
		array_unshift($links, '<a href="' . admin_url('admin.php?page=wc-settings&tab=checkout&section=heylight') . '">' . __('Settings', 'heylight') . '</a>');
		return $links;
	}

	/**
	 * Get instance
	 * @return WC_HeyLight
	 */
	public static function getInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}

WC_HeyLight::getInstance();
